﻿using System;
using System.Collections.Generic;
using VIRP.CRS.BO;
using VIRP.CRS.DAL;

namespace VIRP.CRS.BLL
{
    public class REGISTRY_DEMOGRAPHICSManager
    {
        #region Fields
        #endregion

        #region Properties
        #endregion

        #region Methods

        public static REGISTRY_DEMOGRAPHICS GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REGISTRY_DEMOGRAPHICS_ID)
        {
            REGISTRY_DEMOGRAPHICS objReturn = null;
            REGISTRY_DEMOGRAPHICSDB objDB = new REGISTRY_DEMOGRAPHICSDB();

            objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, REGISTRY_DEMOGRAPHICS_ID);

            return objReturn;
        }

        public static REGISTRY_DEMOGRAPHICS GetItemByPatientId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            REGISTRY_DEMOGRAPHICS objReturn = null;
            REGISTRY_DEMOGRAPHICSDB objDB = new REGISTRY_DEMOGRAPHICSDB();

            objReturn = objDB.GetItemByPatientId(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID);

            return objReturn;
        }

        public static List<REGISTRY_DEMOGRAPHICS> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<REGISTRY_DEMOGRAPHICS> objReturn = null;
            REGISTRY_DEMOGRAPHICSDB objDB = new REGISTRY_DEMOGRAPHICSDB();

            objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

            return objReturn;
        }

        public static Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, REGISTRY_DEMOGRAPHICS objSave)
        {
            Int32 objReturn = 0;
            REGISTRY_DEMOGRAPHICSDB objDB = new REGISTRY_DEMOGRAPHICSDB();

            if (objSave.CREATED == null || objSave.CREATED == DateTime.MinValue)
                objSave.CREATED = DateTime.Now;
            if (objSave.UPDATED == null || objSave.UPDATED == DateTime.MinValue)
                objSave.UPDATED = DateTime.Now;

            if (string.IsNullOrEmpty(objSave.CREATEDBY))
                objSave.CREATEDBY = CURRENT_USER;
            if (string.IsNullOrEmpty(objSave.UPDATEDBY))
                objSave.UPDATEDBY = CURRENT_USER;

            objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REGISTRY_DEMOGRAPHICS_ID)
        {
            Boolean objReturn = false;
            REGISTRY_DEMOGRAPHICSDB objDB = new REGISTRY_DEMOGRAPHICSDB();

            objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, REGISTRY_DEMOGRAPHICS_ID);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, REGISTRY_DEMOGRAPHICS objDelete)
        {
            return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.PATIENT_ID);
        }

        #endregion
    }
}
